*******************************************************************************
*                      68000/68010 Grundprogramm gdpio                        *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                               GDP-Routinen                                  *
*******************************************************************************


* Unterprogramme GDP EF 9366

wait:                           * Warten bis GDP fertig
 btst.b #2,gdp.w                * Bit 2 prfen
 beq.s wait                     * Warten bis auf 1
rts

cmdput:                         * Zeichen an GDP schicken
 tst.b d0                       * Wenn negativ dann putchar
 bmi putchar                    * Sonderzeichenausgabe
cmd:                            * Wert an GDP schicken, alles erlaubt
 btst.b #2,gdp.w                * Ohne Sprung zu wait schneller
 beq.s cmd
 move.b d0,gdp.w                * Befehl ausgeben
rts

erapen:
 btst.b #2,gdp.w                * Pen auf Lschen schalten
 beq.s erapen
 move.b #1,gdp.w                * Schreiben
bra.s setpen1                   * Stift aktiv

setpen:
 btst.b #2,gdp.w                * Pen auf Schreiben schalten
 beq.s setpen
 clr.b gdp.w                    * Lschen
setpen1:
 btst.b #2,gdp.w
 beq.s setpen1
 move.b #2,gdp.w                * Stift aktiv
rts

clear:
 btst.b #2,gdp.w                * Seite in d0
 beq.s clear                    * Warten bis GDP fertig
 and.b #$f0,d0
 move.b d0,page.w               * Seite einstellen
 or.b #4,gdp+1*cpu.w            * Blank
 move.b #6,gdp.w                * Befehl Schirm lschen
 bsr.s wait
 and.b #$fb,gdp+1*cpu.w         * Sichtbar
rts

clrall:
 clr.b viewpage(a5)             * Alle Bildschirmseiten lschen, danach Seite 0
 clr.b wrtpage(a5)              * als Lese und Schreibseite
 moveq #%01010000,d0            * Seite 1
 bsr.s clear
 moveq #%10100000,d0            * Seite 2
 bsr.s clear
 moveq #%11110000,d0            * Seite 3
 bsr.s clear
 moveq #%00000000,d0            * Seite 0
 bsr.s clear
 btst.b #0,ioflag(a5)
 beq.s setpage
 clr.b coscroll(a5)
 clr.b page1.w                  * Nur bei neuer GDP Scroll aus
bra.s setpage

clrinvis:                       * Aktuelle Schreibseite lschen
 movem.l d0-d1,-(a7)
 bsr erapen                     * Lschen
 move.b gdp+3*cpu.w,-(a7)       * Gre beibehalten
 and.b #$f0, gdp+2*cpu.w        * Line = 0
 clr.b gdp+3*cpu.w              * size = max
 move.b #$e,gdp.w               * Y-Register auf Null
 moveq #5-1,d0                  * Counter
clri1:
 clr.b  gdp+8*cpu.w
 clr.b  gdp+9*cpu.w             * Auf Zeilenanfang
 moveq #8-1,d1
clri2:
 move.b #$b,gdp.w               * Befehl Lschen ausgeben
 bsr    wait
dbra d1,clri2
 add.b #64,gdp+$b*cpu.w         * Nchste Zeile
dbra d0,clri1
 bsr setpen                     * Auf Schreiben danach
 move.b (a7)+,gdp+3*cpu.w       * Alte Gre beibehalten
 movem.l (a7)+,d0-d1
rts

newpage:                        * d0 = wrtpage   d1 = viewpage
 move.b d0,wrtpage(a5)
 move.b d1,viewpage(a5)
aktpage:
 move.b viewpage(a5),d0
 ror.b #2,d0                    * 0..3
 or.b wrtpage(a5),d0
 ror.b #2,d0                    * 0..3
setpage:                        * Ausgabe d0 wwrr0000
 or.b xormode(a5),d0            * XOR-Mode anwhlen
setpage1:
 btst.b #2,gdp.w                * Ohne Sprung zu wait schneller
 beq.s setpage1
 move.b d0,page.w               * Seite einstellen
 btst.b #0, transmod(a5)
 beq.s setpage2
 bset.b #5, gdp+2*cpu.w
 bra.s setpage3
setpage2:
 bclr.b #5, gdp+2*cpu.w
setpage3:
 move.b fgcolor(a5),colport.w   * Auch Farbe neu setzen
 move.b bgcolor(a5),colport1.w  * natrlich auch Hintergrund
rts

sync:                           * Horizontalen SYNC abfragen
 clr d0                         * Flag auf Null
 btst.b #1,gdp.w                * gdp syncbit
 beq.s sync1
 tst.b synstate(a5)
 bne.s sync2                    * sync schon abgefragt
 not d0                         * Flag setzen, da Sync
sync1:
 move.b d0,synstate(a5)         * Auch dorthin
rts
sync2:
 tst d0                         * Kein SYNC
rts

* Verzgerungsschleife mit Quarzgenauigkeit, da der GDP64 als Zeitbasis
* verwendet wird.

delay:                          * d0 / 100 Sekunden warten
 tst.l d0
 beq.s delfin                   * Wenn d0=0, dann kein delay
 btst.b #6, keydil(a5)          * GDP-FPGA vorhanden
 beq.s delay0a                  * nein
 move.l d0,-(a7)                * GDP-FPGA, dann d0.l * 6 !!!!!
 add.l d0,d0                    * *2
 add.l (a7)+,d0                 * *3
 add.l d0,d0                    * *6
 bra.s delay0                   * und dann weiter bei delay0
delay0a:
 move.l d0,-(a7)                * hier GDP!
 add.l d0,d0
 add.l d0,d0
 add.l (a7)+,d0                 * d0.l * 5 damit 100 Milisekunden
delay0:
 move.l d0,-(a7)
delay1:
 bsr.s sync                     * Warten auf Syncronisation
 beq.s delay1
 bsr.s autoja                   * Auch autoflip aufrufen
 move.l (a7)+,d0
 subq.l #1,d0                   * Runterzhlen
bne.s delay0
delfin:
rts

autoflip:                       * Automatische Bildseitenumschaltung
 bsr.s sync                     * Nur bei SYNC aktiv
 beq.s auto2                    * Kein sync
autoja:                         * Einsprung delay
 tst.b flip1(a5)                * 4 fach swap
 beq.s auto1
 bsr setturt                    * Nur wenn first
 cmp.b #1,flip1cnt(a5)
 bne.s auto11
 move.b flip1(a5),flip1cnt(a5)  * Zhler neu laden
 addq.b #1,viewpage(a5)         * Leseseite ndern
 and.b #3,viewpage(a5)
 bsr aktpage                    * Neue Seite
bra.s auto1
auto11:
 subq.b #1,flip1cnt(a5)         * Verringern
auto1:
 tst.b flip(a5)                 * 2 fach swap
 beq.s auto2
 bsr setturt                    * Nur wenn first
 cmp.b #1,flipcnt(a5)
 bne.s auto22
 move.b flip(a5),flipcnt(a5)    * Zhler neu laden
 eor.b #1,viewpage(a5)          * Leseseite ndern
bra aktpage
auto22:
 subq.b #1,flipcnt(a5)          * Verringern
auto2:
rts

grmoveto:                       * MOVETO fr Grafik-Paket
 asr #1,d2
moveto:                         * Schreibstift der GDP positionieren
 btst.b #2,gdp.w                * d1 = X  d2 = Y
 beq.s moveto                   * Ohne Sprung zu wait schneller
movetoo:                        * Ohne wait
 move.l a0,-(a7)                * ==> Nur fr 68000/68010
 lea gdp.w,a0
 movep.w d1,8*cpu(a0)           * X Register gesetzt
 movep.w d2,$a*cpu(a0)          * Y Register gesetzt
 movea.l (a7)+,a0
rts

getxy:
 btst.b #2,gdp.w                * d1.l = x  d2.l = y
 beq.s getxy                    * Ohne Sprung zu wait schneller
 move.l a0,-(a7)                * ==> Nur fr 68000/68010
 lea gdp.w,a0
 movep.w 8*cpu(a0),d1           * X Register geladen
 movep.w $a*cpu(a0),d2          * Y Register geladen
 movea.l (a7)+,a0
 asl #4,d1
 ext.l d1
 asr #4,d1                      * Vorzeichen X
 asl #4,d2
 ext.l d2
 asr #4,d2                      * Vorzeichen Y
rts

drawto:                         * Linie ziehen d1 = X  d2 = Y
 movem.l d0-d4,-(a7)            * Innerer Aufruf, da auch spezielle Anwendung
 bsr.s drawtoa
 movem.l (a7)+,d0-d4
rts

drawtoa:
 move d1,d3                     * X und Y merken
 move d2,d4
 bsr.s getxy                    * d3 = dx     d4 = dy
drawt0:
 moveq #$17,d0                  * Vektor ohne Richtung
 sub d3,d1
 bpl.s drawt1                   * Delta X positiv ?
 neg d1                         * Nein, dann negieren
 subq.b #2,d0                   * Richtung X
drawt1:
 sub d4,d2
 bpl.s drawt2                   * Delta Y positiv ?
 neg d2                         * Nein, dann negieren
 subq.b #4,d0                   * Richtung Y
drawt2:
 cmp #255,d1                    * Teilen ntig ?
 bhi.s drawt3                   * Ja
 cmp #255,d2                    * Teilen ?
 bhi.s drawt3                   * Ja
drawt20:
 btst.b #2,gdp.w                * Warten bis gdp fertig
 beq.s drawt20
 move.b d1,gdp+5*cpu.w          * Dx
 move.b d2,gdp+7*cpu.w          * Dy
 move.b d0,gdp.w                * Befehl Linie zeichnen
rts
drawt3:                         * Teilen
 move d1,d3                     * Dx und Dy merken
 move d2,d4
drawt4:
 asr #1,d3                      * Durch zwei teilen
 asr #1,d4
 cmp #255,d3                    * Eventuell weiter teilen
 bhi.s drawt4
 cmp #255,d4                    * Teilen ?
 bhi.s drawt4
drawt40:
 btst.b #2,gdp.w                * Warten bis gdp fertig
 beq.s drawt40
 move.b d3,gdp+5*cpu.w          * Dx
 move.b d4,gdp+7*cpu.w          * Dy
 move.b d0,gdp.w                * Linie zeichnen
 sub d3,d1
 sub d4,d2
bra.s drawt2                    * Rest der Linie

setfig:                         * Alte Figur fest setzen
 clr oldsize(a5)
rts

figur:                          * Figur ausgeben und Alte lschen, wenn da
 move d1,-(a7)
 move.b d0,d1
 lsl #8,d0
 move.b d1,d0                   * X-Vergrerung = Y-Vergrerung
 move (a7)+,d1
figurxy:                        * Figur-Befehl mit getrennter Vergrerung
 movem.l d0-d2/a0,-(a7)
 move oldsize(a5),d0
 beq.s figur1                   * Keine alte Figur vorhanden
 bsr erapen
 move oldx(a5),d1
 move oldy(a5),d2
 movea.l oldadr(a5),a0
 bsr.s figset                   * Alte Figur lschen
figur1:
 movem.l (a7)+,d0-d2/a0
 move d0,oldsize(a5)
 beq.s figur2                   * Keine neue Figur
 move d1,oldx(a5)
 move d2,oldy(a5)
 move.l a0,oldadr(a5)
 bsr setpen
 bra.s figset                   * Neue Figur setzen
figur2:
rts

figset:                         * Figur setzen
 movem.l d0/a0/a1,-(a7)
 lea gdp.w,a1
 bsr moveto                     * Positionieren
 move.b d0,gdp+7*cpu.w
 asr #8,d0
 move.b d0,gdp+5*cpu.w          * Vergrerung eingestellt
figsch:
 move.b (a0)+,d0                * Richtung holen
 ext d0
 move.b figtab(pc,d0),d0        * Neu kodieren
 beq.s figsetf                  * Null ist Ende
figseta:
 btst.b #2,(a1)                 * Warten, bis GDP fertig
 beq.s figseta
 move.b d0,(a1)                 * An GDP ausgeben
bra.s figsch                    * Schleife
figsetf:
 movem.l (a7)+,d0/a0/a1
rts                             * Figur gesetzt

figtab:                         * Tabelle fr Richtungskodierung
 dc.b %00010000                 * Rechts
 dc.b %00010001                 * Rechts-Oben
 dc.b %00010010                 * Oben
 dc.b %00010011                 * Links-Oben
 dc.b %00010110                 * Links
 dc.b %00010111                 * Links-Unten
 dc.b %00010100                 * Unten
 dc.b %00010101                 * Rechts-Unten
 dc.b 3                         * Senken
 dc.b 2                         * Heben
 dc.b 0                         * Ende
 ds 0

setchar:                        * Zeichen im USER-Zeichensatz
                                * der GDP-FPGA setzen
 btst.b #6, keydil(a5)          * GDP-FPGA da?
 beq.s setchare                 * nein
 and #$ff, d0                   * nur Byte gltig
 sub.b #' ', d0                 * auf 0 bis setzen
 bmi.s setchare                 * Fehler < 0
 cmp.b #$60, d0
 bge.s setchare                 * Fehler > $5f
 movem.l d1-d4, -(a7)           * retten
 move.b gdp+2*cpu.w, d2         *
 move.b gdp+8*cpu.w, d3         * GDP-Register retten
 move.b gdp+9*cpu.w, d4         *
 bset.b #4, gdp+2*cpu.w         * User-Zeichensatz auswhlen
 move.b d0, d1
 asl #2, d0                     * *4
 add d1, d0                     * => *5
 move.b d0, gdp+9*cpu.w         * X LSB
 lsr #8, d0
 move.b d0, gdp+8*cpu.w         * X MSB
 move #5-1, d1                  * 5 Byte
setchar1:
 move.b (a0)+, gdp+$e*cpu.w     * bertragen
 dbra d1, setchar1
 move.b d4, gdp+9*cpu.w         *
 move.b d3, gdp+8*cpu.w         * GDP-Register zurck
 move.b d2, gdp+2*cpu.w         *
 movem.l (a7)+, d1-d4
 clr d0
 bra carres
setchare:
 move #-1, d0
 bra carset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             14
 moveq #1,d0                    * Wort, da nur gerade Adressen als Ziel erlaubt
 bsr getadr2                    * Adressierungsart prfen
 bcs nobefehl
rts
gr4014:
 movea.l a4,a0
 move (a3),d0                   * CHK.W
 and #$f1c0,d0
 cmp #$4180,d0
 bne.s gr4016
 move.l #'CHK.',(a0)+
 move.w #'W ',(a0)+
 bsr    check1adr               * Adressierungsart prfen
 bcs.s gr4015
 moveq #1,d0                    * Wort
 bsr getadr2                    * Adressierungsart
 bcs nobefehl
 moveq #9,